#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "initial_setting.h"
#include "adc_flowtron.h"
#include "pdb_flowtron.h"

/*sample callback function incase the user needs to call it in for interrupts*/
void pdb_sample_callback(unsigned char Interrupt_Type)      //function to be called in case of interrupt
{
 switch(Interrupt_Type) 
 {
  
  case PDB_CHANNEL_1_TRIG_A:
      break;
  
  case PDB_CHANNEL_1_TRIG_B:
       break;
  
  case PDB_CHANNEL_2_TRIG_A:
       break;
  
  case PDB_CHANNEL_2_TRIG_B:
       break;
  
  case PDB_IDELAY_INTERRUPT:
       break;
 
}
}
 
void PDB_ADC_Transaction_Ch1(void);
void PDB_ADC_Transaction_Ch2(void);

void main(void) {

   static float Analog_DataA_Ch1;
   static float Analog_DataB_Ch1;
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */
   
   InitConfig();  //Initializes the clock and the bus clock is set to 20MHz       
   
   /*test code to carry conversion on AD2 and AD4 using PDB trigger*/
 
   //initialize the ADC0
   ADC_Init(ADC_0,ADICLK_BUS,ADIV_1,ADC_MODE_16,ADTRG_HW,ADCO_SINGLE,ADC_REFSEL_EXT);
   
   //configures the channel A & B for ADC0 
   ADC_Channel_Config(ADC_0 ,ADC_CHANNEL_A,ADC_AIEN_OFF,ADC_SINGLE_MODE);
   ADC_Channel_Config(ADC_0 ,ADC_CHANNEL_B,ADC_AIEN_OFF,ADC_SINGLE_MODE);
   
   //selects the channel for the A & B                     
   ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD2);  //channel AD2 for A
   ADC_Single_Channel_Select(ADC_CHANNEL_B,ADC_CHANNEL_AD4);  //channel AD4 for B
   
   //initializes PDB module and enables software trigger mode
   PDB_Init(PDB_PRESCALER_2,PDB_ONE_SHOT_MODE,PDB_SW_TRIG_SEL,PDB_IDELAY_INT_DISABLE,0);
   
   //sets the mod and idelay values
   PDB_Set_Mod_Idelay(0xFFFF,0XFFFF);
   
   //sets the delay for ChannelA & ChannelB
   PDB_Set_Ch1_Delay_A(0x000F);
   PDB_Set_Ch1_Delay_B(0xFFFF);
   
   //starts the conversion by giving software trigger
   PDB_Start_SW_Trigger();
   
   Analog_DataA_Ch1= Read_ADC0_A_AnalogValue();
   Analog_DataB_Ch1= Read_ADC0_B_AnalogValue();
    
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}




